package tm.com
{
	import tm.template.MenuButton;
	
	public class TemplateMenu
	{
		private var _menuButonsCollection:Array;
		public var selectedMenuButton:MenuButton;
		
		private static var _instance:TemplateMenu;
		
		public function TemplateMenu()
		{
			_menuButonsCollection = new Array();
		}
		
		public static function getInstance():TemplateMenu
		{
			if( _instance == null ) {
	            _instance = new TemplateMenu();
	        }
	        return _instance;
		}
		
		public function registerMenuButton( buttonClip:MenuButton, buttonID:uint ):void
		{
			_menuButonsCollection[ buttonID ] = buttonClip;
			buttonClip.init( buttonID );
		}
		
		public function switchMenuButton():void
		{
			var currentPage:uint = TemplateState.getInstance().currentTemplatePage;
			if( selectedMenuButton &&  selectedMenuButton.targetPage != currentPage ) {
				selectedMenuButton.rollOut();
				selectedMenuButton = null;
			}
			for( var i:uint=0; i<_menuButonsCollection.length; i++ ) {
				if( (_menuButonsCollection[i] as MenuButton).targetPage == currentPage ) {
					if( (_menuButonsCollection[i] as MenuButton) != selectedMenuButton ) {
						selectedMenuButton = _menuButonsCollection[i] as MenuButton;
						selectedMenuButton.rollOver();
					} 
				}
			}
		}
	}
}